//*************************************************************************************************
//
//	Description:
//		Rendering of billboards simulated on the GPU
//		
//		
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Matt Hobbs
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		Matt             01/08/2007  Created
//
//	<TABLE>
//
//*************************************************************************************************

#if defined(_XBOX) && !defined(_TOOLS_COMPILATION_)
#include "D:\Render\Shaders\stddefs.fxh"
#else
#include "..\..\..\Render\Shaders\stddefs.fxh"
#endif

#if defined(_PS3_)
#define _MINFILTER	LinearMipMapLinear
#define SET_NO_ANISOTROPY MaxAnisotropy = Aniso1;
#else
#define _MINFILTER	Linear
#define SET_NO_ANISOTROPY MaxAnisotropy = 1;
#endif



//-----------------------------------------------------------------------
//
// Transforms
//
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;



//-----------------------------------------------------------------------
//
// Textures
//
texture diffuseTexture : TEXTURE						
<
	string UIName = "Diffuse Texture";
	bool appEdit = true;
>;



//-----------------------------------------------------------------------
//
// Samplers
//

sampler2D diffuseMap : SAMPLER 
< 
	SET_SRGB_TEXTURE
	bool appEdit = false; 
	string SamplerTexture = "diffuseTexture"; 
	string MinFilter = "Linear";
	string MagFilter = "Linear";
	string MipFilter = "Linear";
	string AddressU  = "Clamp";
	string AddressV  = "Clamp";
>
= sampler_state
{
	Texture = < diffuseTexture >;
#if defined(SET_FX_SAMPLER_STATES)
	FX_SAMPLERSTATE_SRGB_TEXTURE
	MinFilter = _MINFILTER;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = Clamp;
	AddressV  = Clamp;
#endif
};



//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

#if !defined(_PC_)
// 360 uses render to vertex buffer to create a stream of positions
// ps3 locks + updates VB on SPU
struct VSINPUT
{
    float4 position  : POSITION;
    float2 texcoord	 : TEXCOORD0;
};
#else
// PC - read positions as a vertex texture fetch
// (render to VB not possible under DX, though ATI does support a workaround using displacements maps)
struct VSINPUT
{
    float2 texcoord	 : TEXCOORD0;
};
#endif

struct VSOUTPUT
{
    float4 position  : POSITION;
    float  size		 : PSIZE;
//    float4 colour	 : COLOR0;
    float2 texcoord	 : TEXCOORD0;
};



//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT VShader( VSINPUT _input)
{
	VSOUTPUT _output;

    // Transform position to the clipping space 
	float4 pos = float4( _input.position.xyz, 0.0f );
    _output.position = mul( float4( pos.xyz, 1.0f ), worldviewproj );
    
    // TODO: proper size calc
    _output.size    = 12.0f - _output.position.z;
    
    // TODO:
    //
    // col - stateless sim based on time alive + shader constant keys 
    // w/h - "" / read from w/h sim tex (keys to set speed and integrate)
    // other params that are stateless?
    //
    //
	    _output.texcoord = _input.texcoord;

    return _output;
}



//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

struct PSINPUT
{
	float2 texCoord : TEXCOORD0;
};

struct PSOUTPUT
{
	COLOUR_OUTPUT_TYPE colour	: COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT fragmentShader( PSINPUT _input )
{
	PSOUTPUT _output;
	
    _output.colour = tex2D( diffuseMap, _input.texCoord );
    
    return _output;
}



//-----------------------------------------------------------------------
//
// Technique(s)
//

technique RenderGPUBillboards
<
	bool supportsSpecialisedLighting = false;
  bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "RenderGPUBillboards";
	int    normalDeferredID		= 2;
	string zprimeBehaviour		= "ERMB_DONT_RENDER";
	string zprimeDOFBehaviour	= "ERMB_DONT_RENDER";
	string shadowGenBehaviour = "ERMB_RENDER_DEFAULT";
	string lowDetailBehaviour	= "ERMB_DONT_RENDER";
>
{
	pass Pass0
	{
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx VShader();
		PixelShader = compile sce_fp_rsx fragmentShader();
#else
		VertexShader = compile vs_3_0 VShader();
		PixelShader = compile ps_3_0 fragmentShader();
#endif
	}
}